<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package magneto
 */

?>

<div class="row align-items-center mb-4 post">
    <div class="col-lg-5 pe-lg-5 blog-item">
        <a href="<?php the_permalink(); ?>">
            <div class="blog-item-image">
                <?=get_the_post_thumbnail(get_the_ID(), 'large', array( 'class' => 'img-fluid', 'fetchpriority'=> 'low') );?>
            </div>
        </a>
    </div>
    <div class="col-lg-7 blog-item">
        <div class="blog-item-content mt-3">
            <div class="d-flex gap-2 mb-3">
                <span>Por: <?=get_the_author_meta('display_name')?></span><span>·</span><span><?=get_the_date()?></span> 
            </div>
            <a href="<?php the_permalink(); ?>"><h2 class="mb-3"><?php the_title(); ?></h2></a>
            <?=the_excerpt()?>
            <div class="blog-categories">
                <?=the_category(' ')?>
            </div>
        </div> 
    </div>
</div>


