<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package magneto
 */

?>

<div class="col-lg-4 blog-item blog-item-square mb-4">
    <a href="<?php the_permalink(); ?>">
        <div class="blog-item-image">
            <?=get_the_post_thumbnail( $id, 'large', array( 'class' => 'img-fluid' ) );?>
        </div>
    </a>
    <div class="blog-item-content mt-3">
        <div class="d-flex gap-2 mb-3">
            <span>Por: <?=get_the_author_meta('display_name')?></span><span>·</span><span><?=get_the_date()?></span> 
        </div>
        <a href="<?php the_permalink(); ?>"><h2 class="mb-3"><?php the_title(); ?></h2></a>
        <?=the_excerpt()?>
        <div class="blog-categories">
            <?=the_category(' ')?>
        </div>
    </div> 
</div>
