<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package magneto
 */

get_header();
?>

<section class="hero-section-blog">
    <div class="hero-content">
        <h1><?=the_title()?></h1>
        <div class="hero-breadcrumbs">
            <a href="https://pimrivieramaya.com/">Home</a> &gt; Blog
        </div>
    </div>
</section>

<?php while ( have_posts() ) : the_post(); ?>

<div class="section-50 blog-single">
	<div class="container">
		<div class="row justify-content-center mb-5">
			
			<div class="col-lg-12 blog-single-tools">
				<div class="d-flex flex-wrap gap-4 align-items-center">
					<div class="d-flex flex-wrap align-items-center gap-2 mt-1">
		                <span class="fs-8 fw-semibold">Written by: <?=get_the_author_meta('display_name')?></span>
		                <span class="fs-6 fw-semibold">·</span>
		                <span class="fs-8 fw-light">Updated <?=get_the_modified_date()?></span> 
		                <span class="fs-6 fw-semibold">·</span>
		                <span class="fs-8 fw-light">
		                	<?=do_shortcode('[rt_reading_time label="" postfix="min" postfix_singular="min"]')?> reading
		                </span> 
		            </div>
		            <div class="blog-categories lh-1 mt-1 mt-lg-0">
		                <?=the_category(' ')?>
		            </div>
				</div>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-3 pe-lg-5 d-none d-lg-block">
				<div id="table-of-contents">
					<div class="table-of-contents mb-3">
						<div class="text-center">
							<p class="mb-0">Table of Contents</p>
						</div>
						<hr>
					</div>
					
					
					<div class="table-of-contents mb-3">
				<div class="widget widget-search mb-4">
					<form role="search" method="get" id="searchform" class="search-form" action="<?=home_url('/')?>">
	                    <div class="search-form-content">
	                    	<i class="far fa-search"></i>
	                        <input type="text" class="form-control" value="<?=get_search_query()?>" name="s" id="s" placeholder="Encontrar artículos...">
	                    </div>
	                </form>
				</div>
				<div class="widget widget-categories mb-4">
					<p class="widget-title fw-semibold mb-0">Categories</p>
					<hr class="my-2">
					<div class="">
						<?=get_category_sidebar()?>
					</div>
				</div>
				<!-- <div class="widget widget-newsletter text-center bg-black">
					<p class="widget-title fw-normal mb-3 text-white fs-7">Suscríbete para recibir más sugerencias de marketing directamente a tu correo.</p>
					<input type="text" name="" class="form-control mb-3" placeholder="Correo elecrónico">
					<input type="submit" name="" class="btn btn-small btn-yellow fs-8" value="Suscribirme">
				</div> -->
			</div>
			
			<div class="d-flex justify-content-end">
						<div class="d-flex flex-row social-sidebar">
							<div class="social-content d-flex align-items-center justify-content-center mb-2 mt-3">
								<a href="https://www.facebook.com/sharer/sharer.php?u=<?=get_permalink()?>" target="_blank">
									<i class="fab fa-facebook-f fs-5"></i></a>
							</div>
							<div class="social-content d-flex align-items-center justify-content-center mb-2">
								<a href="https://www.linkedin.com/sharing/share-offsite/?url=<?=get_permalink()?>" target="_blank">
									<i class="fab fa-linkedin fs-5"></i></a>
							</div>
							<div class="social-content d-flex align-items-center justify-content-center mb-2">
								<a href="whatsapp://send?text=<?=get_permalink()?>" target="_blank">
									<i class="fab fa-whatsapp fs-5"></i></a>
							</div>
						</div>
					</div>
					
				</div>
				
				
				
				
			</div>
			
			
			
			<div class="col-lg-9 pe-lg-5 mb-4 mb-lg-0">
				<div class="blog-single-content position-relative">
					<div class="table-of-contents-movil d-lg-none" id="table-of-contents-movil">
						<div class="d-flex flex-column">
							<a data-bs-toggle="offcanvas" href="#offcanvasTableOfContents" role="button" aria-controls="offcanvasTableOfContents" class="table-of-contents-movil-btn mb-3">
								Table of Contents <i class="fas fa-angle-left mt-2"></i>
							</a>
							<div class="d-flex flex-column social-sidebar align-items-center">
								<div class="social-content d-flex align-items-center justify-content-center mb-3 mt-3">
									<a href="https://www.facebook.com/sharer/sharer.php?u=<?=get_permalink()?>" target="_blank">
										<i class="fab fa-facebook-f fs-5"></i></a>
								</div>
								<div class="social-content d-flex align-items-center justify-content-center mb-3">
									<a href="https://www.linkedin.com/sharing/share-offsite/?url=<?=get_permalink()?>" target="_blank">
										<i class="fab fa-linkedin fs-5"></i></a>
								</div>
								<div class="social-content d-flex align-items-center justify-content-center mb-3">
									<a href="whatsapp://send?text=<?=get_permalink()?>" target="_blank">
										<i class="fab fa-whatsapp fs-5"></i></a>
								</div>
							</div>
						</div>
					</div>
					<?=get_the_post_thumbnail(get_the_ID(), 'large', array( 'class' => 'img-fluid w-100 mb-2'));?>
					<?=the_content()?>
				</div>
				<hr>
				<div class="text-center">
					<!-- <p>Aquí va el Disqus</p> -->
				</div>
			</div>
			<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasTableOfContents" aria-labelledby="offcanvasTableOfContentsLabel">
			  	<div class="offcanvas-header">
			    	<h5 class="offcanvas-title" id="offcanvasTableOfContentsLabel">Table of Contents</h5>
			    	<button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
			  	</div>
			  	<div class="offcanvas-body">
			   		<div class="table-of-contents"></div>
			    </div>
			</div>
			
		</div>
	</div>
</div>

<div class="section-50">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 text-center text-lg-start">
                <h2 class="mb-0 fs-4">Read more related content</h2>
            </div>
            <div class="col-lg-12 mt-3 pb-4">
                <hr class="m-0 hr-yellow">
            </div>
			<?=related_posts_magneto(get_the_ID())?>
		</div>
	</div>
</div>

<?php endwhile; ?>

<?php
get_footer();
