<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package magneto
 */

get_header();
?>

<?php while ( have_posts() ) : the_post(); ?>

<div class="header-single-blog section-50 d-flex align-items-center justify-content-center position-relative overflow-hidden">
	<div class="container">
		<div class="row align-items-center position-relative">
			<div class="col-lg-5">
				<div class="blog-categories lh-1 mb-4">
	                <?=the_category(' ')?>
	            </div>
	            <h1 class="mb-4 text-white"><?=the_title()?></h1>
	            <div class="d-flex gap-2 align-items-center text-white mb-4">
	                <span class="fs-8 fw-light"><?=get_the_date()?></span><span class="fs-5 fw-semibold">·</span><span class="fs-8 fw-light">Actualizado <?=get_the_date()?></span><span class="fs-5 fw-semibold">·</span><span class="fs-8 fw-light">9min lectura</span>
	            </div>
				<div class="d-flex align-items-center">
					<div class="avatar position-relative me-5">
						<?=wp_get_attachment_image(21, 'medium', false, array( 'class' => 'w-100 h-100 object-fit-cover'));?> 
					</div>
					<div>
						<p class="fs-7 fw-normal text-white mb-0">Escrito por:</p>
						<p class="fs-7 fw-semibold text-white mb-0"><?=get_the_author_meta('display_name')?></p>
					</div>
	            </div>
			</div>
			<div class="col-lg-7 ps-lg-5">
				<?=get_the_post_thumbnail(get_the_ID(), 'large', array( 'class' => 'img-fluid w-100' ) );?>
			</div>
		</div>
	</div>
</div>

<style type="text/css">
.header-single-blog{
}
.header-single-blog:before{
	content: '';
	position: absolute;
	left: 0;
	top: 0;
	width: 60%;
	height: 100%;
	background-color: #000;
}
.header-single-blog .blog-categories a:nth-child(even) {
    background-color: #000000;
    color: #ffffff;
    border: 1px white solid;
}
.header-single-blog .avatar{
	width: 70px;
	height: 70px;
}
.header-single-blog .avatar img{
	z-index: 2;
	position: relative;
}
.header-single-blog .avatar::after {
    border-color: transparent transparent rgb(255, 207, 0);
    border-style: solid;
    border-width: 0px 0px 57px 57px;
    bottom: -9px;
    content: "";
    display: block;
    height: 0px;
    position: absolute;
    right: -9px;
    width: 0px;
    z-index: 1;
}
</style>

<div class="section-50 blog-single">
	<div class="container">
		<div class="row justify-content-center mb-4">
			<div class="col-lg-12 text-center mb-4">
				<div class="section-title-blog py-3"></div>
			</div>
		</div>
		<div class="row">
			<div class="col-lg-3 pe-lg-5">
				<div id="table-of-contents">
					<div class="table-of-contents mb-3">
						<div class="text-center">
							<p class="mb-0">Tabla de contenido</p>
						</div>
						<hr>
					</div>
					<div class="d-flex justify-content-end">
						<div class="d-flex flex-column  social-sidebar">
							<div class="social-content d-flex align-items-center justify-content-center mb-2 mt-3">
								<a href="https://www.facebook.com/sharer.php?u=<?=the_permalink()?>" target="_blank">
									<i class="fab fa-facebook-f fs-5"></i></a>
							</div>
							<div class="social-content d-flex align-items-center justify-content-center mb-2">
								<a href=""><i class="fab fa-instagram fs-5"></i></a>
							</div>
							<div class="social-content d-flex align-items-center justify-content-center mb-2">
								<a href=""><i class="fab fa-whatsapp fs-5"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-6 pe-lg-5">
				<div class="blog-single-content">
					<?=the_content()?>
				</div>
				<hr>
				<div class="text-center">
					<p>Aquí va el Disqus</p>
				</div>
			</div>
			<div class="col-lg-3">
				<div class="widget widget-search mb-4">
					<form role="search" method="get" id="searchform" class="search-form" action="<?=home_url('/')?>">
	                    <div class="search-form-content">
	                    	<i class="far fa-search"></i>
	                        <input type="text" class="form-control" value="<?=get_search_query()?>" name="s" id="s" placeholder="Encontrar artículos...">
	                    </div>
	                </form>
				</div>
				<div class="widget widget-categories mb-4">
					<p class="widget-title fw-semibold mb-0">Categorías</p>
					<hr class="my-2">
					<div class="">
						<?=get_category_sidebar()?>
					</div>
				</div>
				<div class="widget widget-newsletter text-center bg-black">
					<p class="widget-title fw-normal mb-3 text-white fs-7">Suscríbete para recibir más sugerencias de marketing directamente a tu correo.</p>
					<input type="text" name="" class="form-control mb-3" placeholder="Correo elecrónico">
					<input type="submit" name="" class="btn btn-small btn-yellow fs-8" value="Suscribirme">
				</div>
			</div>
		</div>
	</div>
</div>

<div class="section-50">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 text-center text-lg-start">
                <h2 class="mb-0 fs-4">Leer más contenidos relacionados</h2>
            </div>
            <div class="col-lg-12 mt-3 pb-4">
                <hr class="m-0 hr-yellow">
            </div>
			<?=related_posts_magneto(get_the_ID())?>
		</div>
	</div>
</div>

<?php endwhile; ?>

<?php
get_footer();
