<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package magneto
 */

get_header();
?>

<section class="hero-section-blog">
    <div class="hero-content">
        <h1>Real Estate News and Blogs in the Riviera Maya</h1>
        <div class="hero-breadcrumbs">
            <a href="https://pimrivieramaya.com/">Home</a> &gt; Blog
        </div>
    </div>
</section>
<div class="section-50">
	<div class="container">
		<?php if ( ! is_paged() ) : ?>
		<div class="row justify-content-center">
			<?php last_post_offset(); ?>
		</div>
		<?php endif; ?>
		
		<div class="main-post">
			<?php
			if ( have_posts() ) :
				while ( have_posts() ) :
					the_post();
					get_template_part( 'template-parts/content', get_post_type() );
				endwhile;
				// the_posts_navigation(); ?>
				<div class="row mt-5">
					<div class="col-lg-12">
						<hr>
					</div>
					<div class="col-lg-12 text-center">
						<?=custom_pagination();?>
					</div>
				</div>
			<?php
			else :
				get_template_part( 'template-parts/content', 'none' );
			endif;
			?>		
		</div>
	</div>
</div>

<?php
get_footer();
