<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=5, shrink-to-fit=no">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-XH3EJZJ0PJ"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-XH3EJZJ0PJ');
    </script>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div class="preloader"></div>

<header id="main-header" class="cbp-af-header <?=(!is_front_page())?'header-scrolled':''?>">
    <nav class="navbar navbar-expand-xl">
        <div class="container-fluid px-5" style="padding-top: 20px;"> <a class="navbar-brand" href="<?= esc_url(home_url('/')); ?>" aria-label="PIM Real Estate">
<img src="<?php echo home_url('/wp-content/uploads/2025/09/logo-blanco.png'); ?>" alt="PIM Real Estate" class="logo-light logo">
<img src="<?php echo home_url('/wp-content/uploads/2025/09/logo-azul.png'); ?>" alt="PIM Real Estate" class="logo-dark logo" >
            </a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#main-nav-content" aria-controls="main-nav-content" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>

            <div class="collapse navbar-collapse marginmenu" id="main-nav-content">
                
                <?php
                wp_nav_menu( array(
                    'theme_location'  => 'primary_menu',
                    'depth'           => 0,
                    'container'       => false,
                    'menu_class'      => 'navbar-nav mx-auto',
                    'fallback_cb'     => '__return_false',
                    'items_wrap'      => '<ul id="%1$s" class="navbar-nav mx-auto mb-2 mb-xl-0 %2$s">%3$s</ul>',
                    'walker'          => new WP_Bootstrap_Navwalker()
                ) );
                ?>

                <!--div class="navbar-right-elements d-flex align-items-center">
                    <a href="/english-version-url" class="nav-link language-switcher">
                        <img src="/wp-content/uploads/ruta/bandera-uk.png" alt="English" style="width: 20px; height: auto; margin-right: 5px;">
                        <span>ENGLISH</span>
                    </a>
                    <a href="#" class="search-icon-wrapper">
                        <i class="fas fa-search"></i>
                    </a>
                </div-->
            </div>
        </div>
    </nav>
</header>

<?php if (is_single()):?>
<div class="progress-container">
    <div class="progress-bari" id="myBar"></div>
</div>
<?php endif ?>