<?php
/**
 * magneto functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package magneto
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.1.0' );
}
function magneto_setup() {
	load_theme_textdomain( 'magneto', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);
	add_theme_support( 'customize-selective-refresh-widgets' );
}
add_action( 'after_setup_theme', 'magneto_setup' );


function magneto_scripts() {
	//wp_enqueue_style( 'bootstrap', 'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.0/css/bootstrap.min.css');
	// wp_enqueue_style('awesome', 'https://pro.fontawesome.com/releases/v6.0.0-beta3/css/all.css');
	// wp_enqueue_style( 'animate', 'https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css');
	// wp_enqueue_style( 'aos', 'https://cdnjs.cloudflare.com/ajax/libs/aos/2.3.4/aos.css');
    wp_enqueue_style( 'awesome', 'https://pro.fontawesome.com/releases/v6.0.0-beta3/css/all.css');
	wp_enqueue_style( 'style', get_template_directory_uri() . '/assets/css/style.css', array(), '1.1');
	wp_enqueue_script( 'jquery', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js', array(), '', true );
	wp_enqueue_script( 'bootstrap', 'https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/5.3.2/js/bootstrap.bundle.min.js', array(), '', true );
	wp_enqueue_script( 'plugins', get_template_directory_uri() . '/assets/js/plugins.min.js', array(), '', true );
	wp_enqueue_script( 'main', get_template_directory_uri() . '/assets/js/main.js', array(), '1.1', true );
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	if(!is_single()){
        wp_dequeue_style( 'classic-theme-styles' );
        wp_dequeue_style( 'global-styles' );
        wp_dequeue_style( 'wp-block-library' );
        wp_dequeue_style( 'wp-block-library-theme' );
	    wp_dequeue_style( 'wc-blocks-style' );
	}
}
add_action( 'wp_enqueue_scripts', 'magneto_scripts' );

function custom_excerpt_length( $length ) {
    return 25;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function remove_headlinks() {
    remove_action( 'wp_head', 'feed_links', 2 );
    remove_action( 'wp_head', 'feed_links_extra', 3 );
    remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
    remove_action( 'wp_print_styles', 'print_emoji_styles' );
    remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
    remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
    remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
}
add_action( 'init', 'remove_headlinks' );

function get_category_sidebar() {
    $categories = get_categories( array(
        'orderby'    => 'count',
        'order'      => 'DESC',
        'hide_empty' => false,
        'exclude'    => 1,
        'number' => 4, 
    ) );
    foreach ( $categories as $category ) { ?>
        <a href="<?=get_term_link($category)?>" class="d-block mb-1">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <p class="mb-0 fs-7"><?=$category->name?> <?='(' . $category->count . ')';?></p>
                </div>
                <div>
                    <div class="btn-icon">
                        <i class="far fa-arrow-right"></i>
                    </div>
                </div>
            </div>
        </a>
    <?php }
}

add_filter( 'get_the_archive_title', function ($title) {    
    if ( is_category() ) {    
            $title = single_cat_title( '', false );    
        } elseif ( is_tag() ) {    
            $title = single_tag_title( '', false );    
        } elseif ( is_author() ) {    
            $title = '<span class="vcard">' . get_the_author() . '</span>' ;    
        } elseif ( is_tax() ) { //for custom post types
            $title = sprintf( __( '%1$s' ), single_term_title( '', false ) );
        }    
    return $title;    
});

function last_post_offset(){
    $query = new WP_Query( array(
        'order' => 'DESC', 
        'orderby' => 'post_date',
        'posts_per_page' => 2,
    ));     
    if ( $query->have_posts() ) :
        while ( $query->have_posts() ) : 
            $query->the_post(); 
            $id = get_post_thumbnail_id();
            ?>
            <div class="col-lg-6 mb-3 mb-lg-0">
                <a href="<?php the_permalink(); ?>">
                    <div class="blog-item-alt">
                        <?php
                        echo wp_get_attachment_image($id, 'medium', false, array( 'class' => 'img-fluid w-100 not-lazyrocket', 'decoding' => 'async', 'fetchpriority'=> 'high'));
                        ?>
                    </div>
                </a>
            </div>
        <?php endwhile; wp_reset_postdata(); 
    else : echo "<p>No News</p>";
    endif; 
}

function add_image_preload_to_header(){
    $query = new WP_Query( array(
        'order' => 'DESC', 
        'orderby' => 'post_date',
        'posts_per_page' => 2,
    ));     
    if ( $query->have_posts() ) :
        while ( $query->have_posts() ) : 
            $query->the_post(); 
            $id = get_post_thumbnail_id();
            $image_thumbnail  = wp_get_attachment_image_url($id, 'thumbnail', true);
            $image_medium = wp_get_attachment_image_url($id, 'medium', true);
            $image_large  = wp_get_attachment_image_url($id, 'large', true);
            $image_full  = wp_get_attachment_image_url($id, 'full', true);
            $preload_images[] = $image_thumbnail;
            $preload_images[] = $image_medium;
            $preload_images[] = $image_large;
            $preload_images[] = $image_full;
        endwhile; wp_reset_postdata(); 
    endif; 
    if ( ! empty( $preload_images ) ) {
        foreach ( $preload_images as $image_src ) {
            echo '<link rel="preload" href="' . esc_url( $image_src ) . '" as="image" type="image/jpeg">';
        }
    }
}
add_action( 'wp_head', 'add_image_preload_to_header' );


function related_posts_magneto($post_id){
    $query = new WP_Query( array(
        'category__in'   => wp_get_post_categories($post_id), 
        'posts_per_page' => 3, 
        'orderby'        => 'rand',
        'order'          => 'DESC',
        'post__not_in'   => array($post_id)
    ));     
    if ( $query->have_posts() ) :
        while ( $query->have_posts() ) : 
            $query->the_post();
            get_template_part( 'template-parts/content-square');
        endwhile; wp_reset_postdata(); 
    endif; 
}

function custom_pagination() {
    global $wp_query;
    $big = 999999999; 
    $paginate_links = paginate_links(array(
        'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages,
        'prev_next' => false, 
        'type' => 'array',
        'end_size' => 1,
        'mid_size' => 2,
    ));

    if ($paginate_links) {
        echo '<div class="pagination">';
        foreach ($paginate_links as $page) {
            echo '<span class="page-numbers">' . $page . '</span>';
        }
        echo '</div>';
    }
}

// 1. REGISTRA LA UBICACIÓN DEL MENÚ PRINCIPAL
function register_my_menus() {
  register_nav_menus(
    array(
      'primary_menu' => __( 'Primary Menu' ),
    )
  );
}
add_action( 'init', 'register_my_menus' );

// 2. REGISTRA EL SCRIPT DEL HEADER
function theme_enqueue_scripts() {
    wp_enqueue_script( 'custom-header-script', get_template_directory_uri() . '/assets/js/custom-scripts.js', array(), '1.0.0', true );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_scripts' );

// NAV WALKER CORRECTO PARA BOOTSTRAP 5
// NAV WALKER CORRECTO Y DEFINITIVO PARA BOOTSTRAP 5
if ( ! class_exists( 'WP_Bootstrap_Navwalker' ) ) {
    class WP_Bootstrap_Navwalker extends Walker_Nav_Menu {
        public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
            $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

            $classes = empty( $item->classes ) ? array() : (array) $item->classes;
            
            // LÍNEA CORREGIDA: Detecta submenús de la forma correcta
            $has_children = in_array( 'menu-item-has-children', $classes, true );

            if ( $has_children ) {
                $classes[] = 'dropdown';
            }
            if ( in_array( 'current-menu-item', $classes, true ) || in_array( 'current-menu-parent', $classes, true ) ) {
                $classes[] = 'active';
            }

            $classes[] = 'nav-item';
            $classes[] = 'menu-item-' . $item->ID;

            $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args, $depth ) );
            $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

            $id = apply_filters( 'nav_menu_item_id', 'menu-item-' . $item->ID, $item, $args, $depth );
            $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

            $output .= $indent . '<li' . $id . $class_names . '>';

            $atts = array();
            $atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
            $atts['target'] = ! empty( $item->target )     ? $item->target     : '';
            $atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
            $atts['href']   = ! empty( $item->url )        ? $item->url        : '';
            
            if ( $has_children ) {
                $atts['data-bs-toggle']   = 'dropdown';
                $atts['aria-expanded']    = 'false';
                $atts['class']            = 'nav-link dropdown-toggle';
            } else {
                $atts['class']            = 'nav-link';
            }
            
            // Active class.
            if ( in_array( 'active', $classes, true ) ) {
                $atts['class'] .= ' active';
            }

            $atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args, $depth );

            $attributes = '';
            foreach ( $atts as $attr => $value ) {
                if ( ! empty( $value ) ) {
                    $value       = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }

            $item_output  = $args->before;
            $item_output .= '<a' . $attributes . '>';
            $item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
            $item_output .= '</a>';
            $item_output .= $args->after;

            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        }

        public function start_lvl( &$output, $depth = 0, $args = null ) {
            if ( isset( $args->item_spacing ) && 'discard' === $args->item_spacing ) {
                $t = '';
                $n = '';
            } else {
                $t = "\t";
                $n = "\n";
            }
            $indent  = str_repeat( $t, $depth );
            $output .= $n . $indent . '<ul class="dropdown-menu">' . $n;
        }
    }
}

