<?php
/**
 * The template for displaying the footer
 *
 * @package magento
 */
?>

<footer class="footer" style="background-color: #0d2340; color: #fff; padding: 70px 0;">
    <div class="container">
        <div class="row">

            <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6">
                <div class="footer-item">
                    <?php 
                    // Usamos la función de WordPress para obtener el logo. Asegúrate de que el ID (13378) sea el correcto.
                    echo wp_get_attachment_image(13686, 'large', false, array('class' => 'img-fluid f-logo mb-3', 'style' => 'max-width: 150px;')); 
                    ?>
                    <div class="text">
                        <p>
                            Our collective was founded in 2016 by a group of licensed real estate agents, architects, marketers, lawyers and developers with a common goal: to offer national and international investors a complete and unbiased service in the process of buying and developing real estate in México.
                        </p>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-lg-2 col-md-6 col-sm-6">
                <div class="footer-item">
                    <h4>Trend Locations</h4>
                    <div class="f-border"></div>
                    <ul class="links">
                        <li><a href="https://pimrivieramaya.com/location/5/akumal/">Akumal</a></li>
                        <li><a href="https://pimrivieramaya.com/location/1/cancun/">Cancún</a></li>
                        <li><a href="https://pimrivieramaya.com/location/8/holbox/">Holbox</a></li>
                        <li><a href="https://pimrivieramaya.com/location/3/playa-del-carmen/">Playa del Carmen</a></li>
                        <li><a href="https://pimrivieramaya.com/location/4/puerto-aventuras/">Puerto Aventuras</a></li>
                        <li><a href="https://pimrivieramaya.com/location/2/puerto-morelos/">Puerto Morelos</a></li>
                        <li><a href="https://webpro.com.mx/asite/blogpimriviera/blog/#">Tulum</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-xl-2 col-lg-2 col-md-6 col-sm-6">
                <div class="footer-item">
                    <h4>Products & Services</h4>
                    <div class="f-border"></div>
                    <ul class="links">
                        <li><a href="https://pimrivieramaya.com/service/">For Buyers</a></li>
                        <li><a href="https://pimrivieramaya.com/service/">For Sellers</a></li>
                        <li><a href="https://pimrivieramaya.com/service/">For Landlords</a></li>
                        <li><a href="https://pimrivieramaya.com/service/">For Tenants</a></li>
                        <li><a href="https://pimrivieramaya.com/service/">For Investors</a></li>
                        <li><a href="https://pimrivieramaya.com/service/">For Developers</a></li>
                    </ul>
                </div>
            </div>

            <div class="col-xl-3 col-lg-3 col-md-6 col-sm-6">
                <div class="footer-item">
                    <h4>Contact Us</h4>
                    <div class="f-border"></div>
                    <ul class="contact-info">
                        <li>
                            <i class="fas fa-map-marker-alt"></i> Carretera Federal 307, Mza 2, Lt 4, Local 214, Plaza Palmeras. C.P. 77717 Playa del Carmen, Q.Roo., México
                        </li>
                        <li>
                            <i class="fas fa-envelope"></i> <a href="mailto:hola@pimrivieramaya.com">hola@pimrivieramaya.com</a>
                        </li>
                        <li>
                            <i class="fas fa-phone-alt"></i> <a href="tel:+529841147343">+52 9841147343</a>
                        </li>
                    </ul>
                    <a href="https://pimrivieramaya.com/contact/" class="btn btn-theme-blue-bg mt-4">Contact us for more information</a>
                </div>
            </div>

        </div>
    </div>
</footer>

<div class="sub-footer" >
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8 col-md-8">
                <p class="copy mb-0">
                    Copyright © <?= date('Y') ?> | Property Investing in México | All Rights Reserved | <a href="https://pimrivieramaya.com/privacy/"> Privacy Policy</a> | Playa del Carmen, México
                </p>
            </div>
            <div class="col-lg-4 col-md-4 text-md-end">
                <ul class="social-list clearfix">
                    <li><a href="https://www.facebook.com/pimrivieramaya/" target="_blank" class="facebook"><i class="fab fa-facebook-f"></i></a></li>
                    <li><a href="https://www.instagram.com/pimrealestate/" target="_blank" class="instagram"><i class="fab fa-instagram"></i></a></li>
                    <li><a href="https://www.youtube.com/channel/UCN84nCiIHLkyrK1EcVSRLHg" target="_blank" class="youtube"><i class="fab fa-youtube"></i></a></li>
                    <li><a href="https://www.linkedin.com/company/pim-real-estate/?_l=es_ES" target="_blank" class="linkedin"><i class="fab fa-linkedin-in"></i></a></li>
                    <li><a href="https://mx.pinterest.com/pimrivieramaya/" target="_blank" class="pinterest"><i class="fab fa-pinterest"></i></a></li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php wp_footer(); ?>

</body>
</html>