<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package magento
 */

?>

<footer>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-3 text-center mb-4 mb-lg-0 justify-content-center">
                <?=wp_get_attachment_image(13378, 'large', false, array( 'class' => 'img-fluid logo-footer'));?> 
            </div>
        </div>      
        <hr>  
        <div class="row align-items-center">
            <div class="col-lg-3 text-center text-lg-start mb-3 mb-lg-0">
                <a href="<?=esc_url(home_url('/aviso-de-privacidad'));?>"><p class="mb-0 copy">Aviso de Privacidad</p></a>
            </div>
            <div class="col-lg-6 text-center mb-3 mb-lg-0">
				<p class="mb-0 copy">Copyright © <?=date('Y')?> | ASESORIA INMOBILIARIA Y ARRENDAMIENTOS EN MEXICO | All Rights Reserved |  <a href="https://pimrivieramaya.com/privacy/"> Privacy Policy</a> | Playa del Carmen, México</p>
                
            </div>
            <div class="col-lg-3 text-center text-lg-end">
                <div class="social d-flex gap-3 justify-content-center justify-content-lg-end">
                    <a href="#" target="_blank" aria-label="Facebook"><i class="fab fa-facebook"></i></a>
                    <a href="#" target="_blank" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" target="_blank" aria-label="Linkedin"><i class="fab fa-linkedin"></i></a>
                    <a href="#" target="_blank" aria-label="Tiktok"><i class="fab fa-tiktok"></i></a>
                    <a href="#" target="_blank" aria-label="Youtube"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>

</body>
</html>
