document.addEventListener('DOMContentLoaded', function() {
    // Busca el header por su clase principal, NO por el ID
    const header = document.querySelector('.cbp-af-header'); 
    
    // Si no encuentra el header, no hace nada
    if (!header) {
        return;
    }

    const scrollOffset = 50; // Píxeles a desplazar para que cambie de color

    const handleScroll = () => {
        // Si el scroll vertical es mayor que el offset
        if (window.scrollY > scrollOffset) {
            // Añade la clase que lo hace blanco
            header.classList.add('header-scrolled');
        } else {
            // Quita la clase para que vuelva a ser transparente
            header.classList.remove('header-scrolled');
        }
    };
    
    // Ejecuta la función cada vez que el usuario hace scroll
    window.addEventListener('scroll', handleScroll);

    // Ejecuta la función una vez al cargar la página por si no está en el inicio
    handleScroll();
});