<?php
/**
 * Partial: Common post meta template
 */

// Defaults - can be overridden
extract(array(
	'is_single'  => false,
	'show_title' => true,
	'show_cat'   => Bunyad::options()->meta_category,
	'show_date'  => Bunyad::options()->meta_date,
	'show_read_time' => Bunyad::options()->meta_read_time,
	'show_comments'  => Bunyad::options()->meta_comments,
	'title_class' => 'post-title-alt',
	'title_tag'   => '',
	'add_class'   => ''
), EXTR_SKIP);

$class = array('post-meta', 'post-meta-b', $add_class);

// Choose heading tag for SEO
if (!$title_tag) {
	$title_tag = $is_single ? 'h1' : 'h2';
}

?>
	<div <?php Bunyad::markup()->attribs('post-meta-wrap', array('class' => $class)); ?>>
		
		<?php if ($show_cat): ?>
		
			<span class="post-cat">	
				<span class="text-in"><?php esc_html_e('In', 'contentberg'); ?></span> 
				<?php Bunyad::get('helpers')->meta_cats(); ?>
			</span>
			
		<?php endif; ?>
	
		
		<?php 
			// Show title? Choose heading tag for SEO
			if ($show_title): 
		?>			
			
			<<?php echo esc_attr($title_tag); ?> class="<?php echo esc_attr($title_class); ?>">
				<?php 
				if ($is_single): 
					the_title(); 
				else: 
				?>
			
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					
				<?php endif; ?>
			</<?php echo esc_attr($title_tag); ?>>
			
		<?php endif; ?>
		
		<?php
		$enlace_actual = 'https://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
		if($enlace_actual == 'https://magneto.mx/blog/' || $enlace_actual == 'https://magneto.mx/blog/page/2/' || $enlace_actual == 'https://magneto.mx/blog/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/3/' || $enlace_actual == 'https://magneto.mx/blog/page/4/' || $enlace_actual == 'https://magneto.mx/blog/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/6/' || $enlace_actual == 'https://magneto.mx/blog/page/7/' || $enlace_actual == 'https://magneto.mx/blog/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/9/' || $enlace_actual == 'https://magneto.mx/blog/page/10/'
		){
		    $class = "below";
		}else{
		    $class = "below2";
		}
		
		?>
		 
		<div class="<?php echo $class; ?>">
		
			<?php if ($show_date): ?>
				<a href="<?php the_permalink(); ?>" class="meta-item date-link"><time class="post-date" datetime="<?php 
					echo esc_attr(get_the_date(DATE_W3C)); ?>"><?php echo esc_html(get_the_date()); ?></time></a>

				<span class="meta-sep"></span>
			<?php endif; ?>
			
			<?php if ($show_comments): ?>
				<span class="meta-item comments"><a href="<?php echo esc_url(get_comments_link()); ?>"><?php comments_number(); ?></a></span>

				<span class="meta-sep"></span>
			<?php endif; ?>
            
                	<?php if ($show_read_time): ?>
				<span class="meta-item read-time"><?php echo esc_html(Bunyad::helpers()->reading_time()); ?></span>
			<?php endif; ?>
			
			<?php 
			wp_reset_postdata();
				if($enlace_actual == 'https://magneto.mx/blog/' || $enlace_actual == 'https://magneto.mx/blog/page/2/' || $enlace_actual == 'https://magneto.mx/blog/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/3/' || $enlace_actual == 'https://magneto.mx/blog/page/4/' || $enlace_actual == 'https://magneto.mx/blog/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/6/' || $enlace_actual == 'https://magneto.mx/blog/page/7/' || $enlace_actual == 'https://magneto.mx/blog/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/page/9/' || $enlace_actual == 'https://magneto.mx/blog/page/10/' || $enlace_actual =='https://magneto.mx/blog/inbound-marketing/'
		|| $enlace_actual == 'https://magneto.mx/blog/diseno-web/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/2/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/3/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/4/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/6/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/7/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/9/' || $enlace_actual == 'https://magneto.mx/blog/inbound-marketing/page/10/'
		|| $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/2/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/3/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/4/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/6/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/7/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/9/' || $enlace_actual == 'https://magneto.mx/blog/diseno-web/page/10/'
		|| $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/'
		|| $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/2/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/3/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/4/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/6/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/7/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/9/' || $enlace_actual == 'https://magneto.mx/blog/desarrollo-de-software/page/10/'
		
		|| $enlace_actual == 'https://magneto.mx/blog/marketing-digital/'
		|| $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/2/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/3/'
		|| $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/3/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/4/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/5/'
		|| $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/6/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/7/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/8/'
		|| $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/9/' || $enlace_actual == 'https://magneto.mx/blog/marketing-digital/page/10/'
		){
			
		
		}else{
		    //echo do_shortcode( '[kkstarratings]' );  
		}		
			
			?>
                

		
		</div>
		
	</div>